﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NUnit.Framework;
using Inet.Viewer.WinForms.Prompt;
using Inet.Viewer.Data;

namespace Inet.Viewer.test.WinForms
{
    [TestFixture]
    class TestDatePromptField
    {
        [Test]
        public void TestTypicalCase()
        {
            PromptData pDateNoDefaultValues = new PromptData(
    "date2", null, "desc2", new string[] {},
    new string[] {}, PromptData.Date, true, false, false, true,
    false, false, null, "Date(2000,1,1)", "Date(2015,12,31)"
    );
            PromptData pDateWithDefaultValues = new PromptData(
    "date", null, "desc", new string[] { "Date(2004,1,1)", "Date(2005,1,1)" },
    new string[] { "desc1", "desc2" }, PromptData.Date, true, false, false, true,
    false, false, null, "Date(2000,1,1)", "Date(2015,12,31)"
    );
            List<PromptData> prompts = new List<PromptData>();
            prompts.Add(pDateNoDefaultValues);
            prompts.Add(pDateWithDefaultValues);
            PromptDialogForm d = new PromptDialogForm(prompts, new PromptPanelBuilder(), false);
            d.Show();
            ((DatePromptField)d.panel.Controls[0]).dateTimePicker1.Value = new DateTime(2002, 1, 1);
            d.promptTree.SelectedNode = d.AllNodes[d.AllNodes.IndexOf(d.promptTree.SelectedNode) + 1];
            Assert.AreEqual(1, d.AllNodes.IndexOf(d.promptTree.SelectedNode));
            d.promptTree.SelectedNode = d.AllNodes[d.AllNodes.IndexOf(d.promptTree.SelectedNode) - 1];
            Assert.AreEqual("Date(2002,1,1)", ((DatePromptField)d.panel.Controls[0]).Value.StringRepresentation);
            ((DatePromptField)d.panel.Controls[0]).dateTimePicker1.Value = new DateTime(2030, 1, 1);
            d.promptTree.SelectedNode = d.AllNodes[d.AllNodes.IndexOf(d.promptTree.SelectedNode) + 1];
            Assert.AreEqual(0, d.AllNodes.IndexOf(d.promptTree.SelectedNode));
            ((DatePromptField)d.panel.Controls[0]).dateTimePicker1.Value = new DateTime(2002, 1, 1);
            d.promptTree.SelectedNode = d.AllNodes[d.AllNodes.IndexOf(d.promptTree.SelectedNode) + 1];
            Assert.AreEqual(1, d.AllNodes.IndexOf(d.promptTree.SelectedNode));

            DefaultValueField f = d.panel.Controls[0] as DefaultValueField;
            DatePromptField inner = (DatePromptField)f.customPromptField;
            Assert.AreEqual(3, f.cmbDefaultValues.Items.Count); // 2 regular items + custom value item = 3 
            f.cmbDefaultValues.SelectedIndex = 2;
            string oldText = f.cmbDefaultValues.Text;
            Assert.AreEqual("Date(2005,1,1)", f.Value.StringRepresentation);
            f.chbNoValue.Checked = true;
            Assert.IsFalse(f.cmbDefaultValues.Enabled);
            Assert.AreEqual("", f.Value.StringRepresentation);
            f.chbNoValue.Checked = false;
            Assert.AreEqual("Date(2005,1,1)", f.Value.StringRepresentation);
            Assert.AreEqual(oldText, f.cmbDefaultValues.Text);
            f.cmbDefaultValues.SelectedIndex = 0;
            Assert.IsTrue(inner.dateTimePicker1.Enabled);
            inner.dateTimePicker1.Value = new DateTime(2002, 1, 1);
            Assert.AreEqual("Date(2002,1,1)", f.Value.StringRepresentation);
            d.promptTree.SelectedNode = d.AllNodes[d.AllNodes.IndexOf(d.promptTree.SelectedNode) - 1];
            Assert.AreEqual(0, d.AllNodes.IndexOf(d.promptTree.SelectedNode));
            Assert.AreEqual("Date(2002,1,1)", ((DatePromptField)d.panel.Controls[0]).Value.StringRepresentation);
            d.promptTree.SelectedNode = d.AllNodes[d.AllNodes.IndexOf(d.promptTree.SelectedNode) + 1];
            f = d.panel.Controls[0] as DefaultValueField;
            inner = (DatePromptField)f.customPromptField;

            Assert.AreEqual(0, f.cmbDefaultValues.SelectedIndex);
            f.cmbDefaultValues.SelectedIndex = 1;
            Assert.AreEqual("Date(2004,1,1)", f.Value.StringRepresentation);
            d.promptTree.SelectedNode = d.AllNodes[d.AllNodes.IndexOf(d.promptTree.SelectedNode) - 1];
            d.promptTree.SelectedNode = d.AllNodes[d.AllNodes.IndexOf(d.promptTree.SelectedNode) + 1];
            Assert.AreEqual(1, f.cmbDefaultValues.SelectedIndex);
            Assert.AreEqual("Date(2004,1,1)", f.Value.StringRepresentation);

            f.cmbDefaultValues.SelectedIndex = 0;
            Assert.IsFalse(f.chbNoValue.Checked);
            Assert.IsTrue(inner.dateTimePicker1.Enabled);
            Assert.IsTrue(f.cmbDefaultValues.Enabled);
        }

        [Test]
        public void TestDateWithDefaultValuesOnly()
        {
            PromptData pDateWithDefaultValues = new PromptData(
    "date", null, "desc", new string[] { "Date(2004,1,1)", "Date(2005,1,1)" },
    new string[] { "desc1", "desc2" }, PromptData.Date, true, false, false, false,
    false, false, null, "Date(2000,1,1)", "Date(2015,12,31)"
    );
            List<PromptData> prompts = new List<PromptData>();
            prompts.Add(pDateWithDefaultValues);
            PromptDialogForm d = new PromptDialogForm(prompts, new PromptPanelBuilder(), false);
            d.Show();
            DefaultValueField f = d.panel.Controls[0] as DefaultValueField;
            Assert.IsFalse(f.cmbDefaultValues.SelectedItem.ToString().Length == 0);
        }
    }
}
